#
# Copyright  (C) 1985-2016 Intel Corporation. All rights reserved.
#
# The information and source code contained herein is the exclusive property
# of Intel Corporation and may not be disclosed, examined, or reproduced in
# whole or in part without explicit written authorization from the Company.
#

#!/bin/csh

if ($?INSTALL_DIR) then
	set INTEL_INSTALL_DIR_SAVED=$INSTALL_DIR
endif

if ($?NDK_DIR) then
	set INTEL_NDK_DIR_SAVED=$NDK_DIR
endif

set INSTALL_DIR="<INSTALLDIR>"
set NDK_DIR="<NDK_DIR>"
set NDK_ARCH=''

if ( $#argv == 0 ) then
	set INTEL_TARGET_ARCH=$COMPILERVARS_ARCHITECTURE
	set INTEL_TARGET_PLATFORM=$COMPILERVARS_PLATFORM
else
	set INTEL_TARGET_ARCH=$1
	set INTEL_TARGET_PLATFORM=$2
endif

if !($?PATH) then
	setenv PATH "$INSTALL_DIR/bin/${INTEL_TARGET_ARCH}"
else
	setenv PATH "$INSTALL_DIR/bin/${INTEL_TARGET_ARCH}:${PATH}"
endif
if ( $INTEL_TARGET_ARCH == "ia32" ) then
	set NDK_ARCH=x86
	if ( -d "$INSTALL_DIR/mpirt/bin/ia32_lin" ) then
		setenv PATH "$PATH:$INSTALL_DIR/mpirt/bin/ia32_lin"
	endif
else if ( $INTEL_TARGET_ARCH == "intel64" ) then 
	set NDK_ARCH=x86_64
endif

if ( "$INTEL_TARGET_PLATFORM" == "android" ) then
	setenv ICCCFG "$INSTALL_DIR/bin/intel64/icc_and.cfg"
	setenv ICPCCFG "$INSTALL_DIR/bin/intel64/icpc_and.cfg"
	setenv XIARCFG "$INSTALL_DIR/bin/intel64/xiar_and.cfg"
	setenv XILDCFG "$INSTALL_DIR/bin/intel64/xild_and.cfg"
else
	unsetenv ICCCFG
	unsetenv ICPCCFG
	unsetenv XIARCFG
	unsetenv XILDCFG
endif

foreach a (9 10 11 12 13 14 15 16 17 18 19 21 L)
	if ( -d "${NDK_DIR}/platforms/android-$a/arch-$NDK_ARCH" ) then
		setenv ANDROID_SYSROOT "${NDK_DIR}/platforms/android-$a/arch-$NDK_ARCH"
		break;
	endif
end

foreach g (4.6 4.8 4.9)
	foreach h (linux-x86 linux-x86_64)
		if ( -d "${NDK_DIR}/toolchains/$NDK_ARCH-$g/prebuilt/$h" ) then
			setenv ANDROID_GNU_X86_TOOLCHAIN "${NDK_DIR}/toolchains/$NDK_ARCH-$g/prebuilt/$h"
			break;
		endif
	end
end

if ( "`uname`" == "Darwin" ) then
	# DYLD_LIBRARY_PATH is used on OS X*
	if !($?DYLD_LIBRARY_PATH) then
		setenv DYLD_LIBRARY_PATH $INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}
	else
		setenv DYLD_LIBRARY_PATH $INSTALL_DIR/compiler/lib:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}:${DYLD_LIBRARY_PATH}
	endif
	if !($?NLSPATH) then
		setenv NLSPATH $INSTALL_DIR/compiler/lib/locale/en_US/%N
	else
		setenv NLSPATH $INSTALL_DIR/compiler/lib/locale/en_US/%N:${NLSPATH}
	endif
	if !($?INTEL_LICENSE_FILE) then
		setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses"
	else
		setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:/Users/Shared/Library/Application Support/Intel/Licenses:${INTEL_LICENSE_FILE}"
	endif
	if !($?MANPATH) then
		if (-s /usr/bin/manpath) then
			setenv MANPATH $INSTALL_DIR/../../man/common:`manpath`:
		else
			setenv MANPATH $INSTALL_DIR/../../man/common:${MANPATH}:
		endif
	endif
else
	if ( -d "$INSTALL_DIR/compiler/lib/mic" ) then
		if !($?MIC_LD_LIBRARY_PATH) then
			setenv MIC_LD_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/mic"
		else
			setenv MIC_LD_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/mic:${MIC_LD_LIBRARY_PATH}"
		endif
		if !($?MIC_LIBRARY_PATH) then
			setenv MIC_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/mic"
		else
			setenv MIC_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/mic:${MIC_LIBRARY_PATH}"
		endif
	endif
	if ( -d "$INSTALL_DIR/mpi/mic/lib" ) then
		if !($?MIC_LD_LIBRARY_PATH) then
			setenv MIC_LD_LIBRARY_PATH "$INSTALL_DIR/mpi/mic/lib"
		else
			setenv MIC_LD_LIBRARY_PATH "$INSTALL_DIR/mpi/mic/lib:${MIC_LD_LIBRARY_PATH}"
		endif
		if !($?MIC_LIBRARY_PATH) then
			setenv MIC_LIBRARY_PATH "$INSTALL_DIR/mpi/mic/lib"
		else
			setenv MIC_LIBRARY_PATH "$INSTALL_DIR/mpi/mic/lib:${MIC_LIBRARY_PATH}"
		endif
	endif

	if !($?LD_LIBRARY_PATH) then
		setenv LD_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}_lin"
	else
		setenv LD_LIBRARY_PATH "$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}:$INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}_lin:${LD_LIBRARY_PATH}"
	endif
	if ( $INTEL_TARGET_ARCH == "ia32" && -d "$INSTALL_DIR/mpirt/lib/ia32_lin" ) then
		setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}:$INSTALL_DIR/mpirt/lib/ia32_lin"
	endif
	if !($?NLSPATH) then
		setenv NLSPATH $INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}/locale/%l_%t/%N
	else
		setenv NLSPATH $INSTALL_DIR/compiler/lib/${INTEL_TARGET_ARCH}/locale/%l_%t/%N:${NLSPATH}
	endif
	if !($?INTEL_LICENSE_FILE) then
		setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses"
	else
		setenv INTEL_LICENSE_FILE "$INSTALL_DIR/licenses:/opt/intel/licenses:${HOME}/intel/licenses:${INTEL_LICENSE_FILE}"
	endif
	if (!($?MANPATH) && -d "$INSTALL_DIR/../../man/common") then
		if (-s /usr/bin/manpath) then
			setenv MANPATH `cd $INSTALL_DIR/../../man/common && pwd`:`manpath`
		else
			setenv MANPATH `cd $INSTALL_DIR/../../man/common && pwd`
		endif
        else if ( -d "$INSTALL_DIR/../../man/common" ) then
		setenv MANPATH `cd $INSTALL_DIR/../../man/common && pwd`:${MANPATH}
	endif
endif

if ($?INTEL_INSTALL_DIR_SAVED) then
	set INSTALL_DIR=$INTEL_INSTALL_DIR_SAVED
else
	unset INSTALL_DIR
endif
if ($?INTEL_NDK_DIR_SAVED) then
	set NDK_DIR=$INTEL_NDK_DIR_SAVED
else
	unset NDK_DIR
endif
unset INTEL_INSTALL_DIR_SAVED
unset INTEL_NDK_DIR_SAVED

